******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close


***********
* Table 8 *
***********
use "$internal_dir/data/panel.dta", clear
cap erase "$external_dir/output/table8.txt"
xtset country year

*Variable lists
local vars "HHI log_rgdp_pc_av log_pop_div100 remit_gdp dom_credit_prop_gdp landarea_milkm distance_milkm p_stock_nonus"
local int_list ""
foreach var in `vars' {
	
	*Variable lists
	local int_list "`int_list' c.HI#c.`var'"
	qui sum missing_`var'
	if r(max)>0 {
		local int_list "`int_list' 1.missing_`var'#c.HI"
		}
		
	}

*Each control individually
foreach var in `vars' {
qui sum missing_`var'
	if r(max)>0 {
		xtreg p_inflows i.year c.year#i.country HI c.HI#c.p_stock1980 c.HI#c.`var' 1.missing_`var'#c.HI, fe cl(country)
		outreg2 using "$external_dir/output/table8", append nocons dec(4) noparen ///
			keep(HI c.HI#c.p_stock1980 c.HI#c.`var' 1.missing_`var'#c.HI)
		}
	if r(max)==0 {
		xtreg p_inflows i.year c.year#i.country HI c.HI#c.p_stock1980 c.HI#c.`var', fe cl(country)
		outreg2 using "$external_dir/output/table8", append nocons dec(4) noparen ///
			keep(HI c.HI#c.p_stock1980 c.HI#c.`var')
		}
	
	}

*Robustness specification with all control variables
xtreg p_inflows i.year c.year#i.country HI c.HI#c.p_stock1980 `int_list', fe cl(country)

	*Output results and disclosure statistics
	outreg2 using "$external_dir/output/table8", append nocons dec(4) noparen ///
		keep(HI c.HI#c.p_stock1980 `int_list')



